

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/data/controller/auth/auth/registration_controller.dart';

import '../../../../../core/utils/dimensions.dart';
import '../../../../../core/utils/my_color.dart';
import '../../../../../core/utils/style.dart';
import '../../../../components/divider/horizontal_divider.dart';
import '../../../auth/registration/widget/country_bottom_sheet.dart';
class ConversionRateFieldWidget extends StatelessWidget {

  final String amount;
  final String country;
  final String label;
  final double? customWidth;

  const ConversionRateFieldWidget({
    super.key,
    required this.amount,
    required this.country,
    required this.label,
    this.customWidth,
  });

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return GetBuilder<RegistrationController>(
      builder: (controller) => Container(
        padding: const EdgeInsets.symmetric(horizontal: Dimensions.space12),
        width: customWidth ?? size.width * .7,
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(Dimensions.space8),
            border: Border.all(color: MyColor.gray300),
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                color: Colors.black.withOpacity(0.2), // Shadow color
                blurRadius: 1,
              ),
            ]
        ),
        child: Row(
          children: [
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                const SizedBox(height:Dimensions.space5),
                Text(label.tr,style: mediumSmall.copyWith(color: MyColor.bodyTextColor)),
                const SizedBox(height: Dimensions.space5),
                 Text(amount.tr,style: boldLarge),
                const SizedBox(height: Dimensions.space5),
              ],
            ),
            const Spacer(),
            const HorizontalDivider(dividerHeight: 40),

            GestureDetector(
              onTap: () {
                CountryBottomSheet.profileCompleteCountryBottomSheet(context, Get.find());
              },
              child: Row(
                children: [
                  const CircleAvatar(
                    radius: 10,
                    backgroundColor: Colors.lightBlue,
                  ),
                  const SizedBox(width: 5),
                  Text(country.tr,style: boldLarge),
                  const Icon(Icons.expand_more,color: MyColor.boldTextColor)
                ],
              ),
            ),

          ],
        ),
      ),
    );
  }
}